/*
 * Decompiled with CFR 0.152.
 */
package com.mangomilk.design_decor.blocks.ceiling_fan;

import com.mangomilk.design_decor.blocks.ceiling_fan.CeilingFanBlockEntity;
import com.mangomilk.design_decor.registry.CDDPartialModels;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityVisual;
import com.simibubi.create.content.kinetics.base.RotatingInstance;
import com.simibubi.create.foundation.render.AllInstanceTypes;
import dev.engine_room.flywheel.api.instance.Instance;
import dev.engine_room.flywheel.api.visual.DynamicVisual;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.lib.instance.FlatLit;
import dev.engine_room.flywheel.lib.instance.TransformedInstance;
import dev.engine_room.flywheel.lib.model.Models;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import dev.engine_room.flywheel.lib.visual.SimpleDynamicVisual;
import java.util.function.Consumer;
import net.createmod.catnip.math.AngleHelper;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class CeilingFanVisual
extends KineticBlockEntityVisual<CeilingFanBlockEntity>
implements SimpleDynamicVisual {
    protected final RotatingInstance shaft;
    protected final TransformedInstance fan;
    protected float lastAngle = Float.NaN;
    protected final Matrix4f baseTransform = new Matrix4f();

    public CeilingFanVisual(VisualizationContext context, CeilingFanBlockEntity blockEntity, float partialTick) {
        super(context, (KineticBlockEntity)blockEntity, partialTick);
        Direction.Axis axis = this.rotationAxis();
        this.shaft = (RotatingInstance)this.instancerProvider().instancer(AllInstanceTypes.ROTATING, Models.partial((PartialModel)AllPartialModels.SHAFT_HALF)).createInstance();
        this.shaft.setup((KineticBlockEntity)blockEntity).setPosition((Vec3i)this.getVisualPosition()).rotateToFace(Direction.SOUTH, Direction.DOWN.m_122424_()).setChanged();
        this.fan = (TransformedInstance)this.instancerProvider().instancer(AllInstanceTypes.SCROLLING_TRANSFORMED, Models.partial((PartialModel)CDDPartialModels.CEILING_FAN)).createInstance();
        Direction align = Direction.m_122387_((Direction.Axis)axis, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE);
        ((TransformedInstance)((TransformedInstance)this.fan.translate((Vec3i)this.getVisualPosition())).center()).rotate((Quaternionfc)new Quaternionf().rotateTo(0.0f, 1.0f, 0.0f, (float)align.m_122429_(), (float)align.m_122430_(), (float)align.m_122431_()));
        this.baseTransform.set((Matrix4fc)this.fan.pose);
        this.animate(blockEntity.angle);
    }

    public void beginFrame(DynamicVisual.Context context) {
        float partialTicks = context.partialTick();
        float speed = ((CeilingFanBlockEntity)this.blockEntity).visualSpeed.getValue(partialTicks) * 3.0f / 10.0f;
        float angle = ((CeilingFanBlockEntity)this.blockEntity).angle + speed * partialTicks;
        if ((double)Math.abs(angle - this.lastAngle) < 0.001) {
            return;
        }
        this.animate(angle);
        this.lastAngle = angle;
    }

    private void animate(float angle) {
        ((TransformedInstance)this.fan.setTransform((Matrix4fc)this.baseTransform).rotateY(AngleHelper.rad((double)angle)).uncenter()).setChanged();
    }

    public void update(float pt) {
        this.shaft.setup((KineticBlockEntity)this.blockEntity).setChanged();
    }

    public void updateLight(float partialTick) {
        this.relight(new FlatLit[]{this.shaft, this.fan});
    }

    protected void _delete() {
        this.shaft.delete();
        this.fan.delete();
    }

    public void collectCrumblingInstances(Consumer<Instance> consumer) {
        consumer.accept((Instance)this.shaft);
        consumer.accept((Instance)this.fan);
    }
}

